/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.p.service.serviceaction.repair;

import com.ibm.hwmca.base.pa.system.RemoteConsoleSystem;
import com.ibm.hwmca.fw.domain.Domain;
import com.ibm.hwmca.fw.domain.DomainIdentifier;
import com.ibm.hwmca.fw.domain.DomainManager;
import com.ibm.hwmca.fw.pa.system.PASystem;
import com.ibm.hwmca.fw.persist.PersistentData;
import com.ibm.hwmca.fw.service.panel.CommonDataBean;
import com.ibm.hwmca.fw.service.panel.GenericGui;
import com.ibm.hwmca.fw.service.serviceaction.ServiceActionException;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.p.service.panel.PBContinueFromPrimaryHMC;
import com.ibm.hwmca.xfw.pa.domain.DistributedAnalysisDomain;
import com.ibm.hwmca.xfw.service.serviceaction.DefaultServiceAction;
import java.util.HashMap;
import java.util.Map;

public class PIRepair
extends DefaultServiceAction {
    private static final String TRACE_MASKT = "XRVPRPRT";
    private static final String TRACE_MASKF = "XRVPRPRF";
    private static final String TRACE_MASKD = "XRVPRPRD";

    public PIRepair() {
        Trace.trace(TRACE_MASKT, "<> PIRepair default ctor");
    }

    public PIRepair(PersistentData persistentData) throws ServiceActionException {
        super(persistentData);
        Trace.trace(TRACE_MASKT, "<> PIRepair persistent data ctor. persistentData: " + persistentData);
    }

    public void start(Map userData) throws ServiceActionException {
        Trace.trace(TRACE_MASKT, "-> PIRepair.start");
        if (PIRepair.proceedTest(userData)) {
            this.setRulesFile("data/service/rules/p/repair/PIRepairAndVerifyRules.xml");
            super.start(userData);
        } else {
            Trace.trace(TRACE_MASKT, "PIRepair.start proceedTest returned false - returning without starting");
        }
        Trace.trace(TRACE_MASKT, "<- PIRepair.start");
    }

    public static boolean proceedTest(Map userData) {
        boolean proceed = true;
        String domainKey = (String)userData.get("MANAGED_SYSTEM_TYPE") + "-" + (String)userData.get("MANAGED_SYSTEM_MODEL") + "/" + (String)userData.get("MANAGED_SYSTEM_SERIAL");
        Trace.trace(TRACE_MASKF, "PIRepair.proceedTest - testing for primary/secondary against domain key: " + domainKey);
        DomainIdentifier domainId = new DomainIdentifier(domainKey);
        Domain domain = DomainManager.getDomainManager().get(domainId);
        if (domain != null) {
            if (domain instanceof DistributedAnalysisDomain) {
                if (!((DistributedAnalysisDomain)domain).isPrimary()) {
                    PASystem pas = ((DistributedAnalysisDomain)domain).getPrimary();
                    if (pas != null) {
                        if (pas instanceof RemoteConsoleSystem) {
                            GenericGui displayHandle = (GenericGui)userData.get("DISPLAY_HANDLE");
                            PBContinueFromPrimaryHMC bean = new PBContinueFromPrimaryHMC();
                            HashMap<String, String> substitutionMap = new HashMap<String, String>();
                            substitutionMap.put("domain", domainKey);
                            String primaryHostName = ((RemoteConsoleSystem)pas).getRESystemName();
                            Trace.trace(TRACE_MASKF, "PIRepair.proceedTest primary host is >" + primaryHostName + "<");
                            if (primaryHostName != null && primaryHostName.trim().length() > 0) {
                                primaryHostName = PIRepair.formatPrimaryHostName(primaryHostName);
                                proceed = false;
                                substitutionMap.put("hostname", primaryHostName);
                                bean.setDataMap(substitutionMap);
                                Trace.trace(TRACE_MASKF, "PIRepair.proceedTest telling user to go to HMC at hostname " + primaryHostName + " to repair this domain");
                                try {
                                    displayHandle.replace("com.ibm.hwmca.fw.service.panel.res.CommonPanels", ((CommonDataBean)bean).getTemplateName(), bean, userData);
                                }
                                catch (Exception toss) {}
                            } else {
                                Trace.trace(TRACE_MASKF, "PIRepair.proceedTest Assuming primary because we couldn't determine the hostname of the actual primary");
                            }
                        } else {
                            Trace.trace(TRACE_MASKF, "PIRepair.proceedTest - Assuming primary because the PASystem for the primary is NOT a RemoteConsoleSystem; class=" + (pas == null ? "null" : pas.getClass().getName()));
                        }
                    } else {
                        Trace.trace(TRACE_MASKF, "PIRepair.proceedTest - Assuming primary because the PASystem for the primary is NULL");
                    }
                } else {
                    Trace.trace(TRACE_MASKF, "PIRepair.proceedTest - Assuming primary because domain isPrimary==true");
                }
            } else {
                Trace.trace(TRACE_MASKF, "PIRepair.proceedTest - Assuming primary because domain is not a DistributedAnalysisDomain");
            }
        } else {
            Trace.trace(TRACE_MASKF, "PIRepair.proceedTest - Assuming primary because domain==null");
        }
        return proceed;
    }

    private static String formatPrimaryHostName(String primarySystemId) {
        int slash;
        String toRet = "";
        toRet = primarySystemId == null ? "unknown" : ((slash = (primarySystemId = primarySystemId.trim()).indexOf(47)) == -1 ? primarySystemId : (slash == 0 ? primarySystemId.substring(1) : primarySystemId.substring(0, slash)));
        return toRet;
    }
}

